/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.pa.sql.ExposedField;
import filenet.pa.sql.UDFMetaData;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.pa.PAActionCommand;
import filenet.vw.apps.taskman.pa.PADataFieldPropertyPanel;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.PADataFieldsNode;
import filenet.vw.apps.taskman.pa.images.VWImageLoader;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;

public class PADataFieldNode
extends VWTaskBaseNode {
    private PADataFieldsNode m_parent = null;
    private PADataFieldPropertyPanel m_propertyPanel = null;
    private String m_fieldName = "";
    private int m_fieldType = -1;
    private boolean m_bIsMeasure = false;
    private Object[] m_ranges = null;
    private int m_cubes = 0;
    private int m_cubeOptions = 0;
    protected static final ImageIcon iconMeasure32 = VWImageLoader.createImageIcon("pameasure_32.gif");
    protected static final ImageIcon iconMeasure16 = VWImageLoader.createImageIcon("pameasure_16.gif");
    protected static final ImageIcon iconDimension32 = VWImageLoader.createImageIcon("padimension_32.gif");
    protected static final ImageIcon iconDimension16 = VWImageLoader.createImageIcon("padimension_16.gif");

    public PADataFieldNode(PADataFieldsNode parent, String uniqueName, String fieldName, int fieldType, boolean bMeasure, int cubes, int cubeOptions, Object[] ranges) throws Exception {
        super(uniqueName);
        this.setIcons(bMeasure);
        this.m_parent = parent;
        this.m_fieldName = fieldName;
        this.m_fieldType = fieldType;
        this.m_bIsMeasure = bMeasure;
        this.m_cubes = cubes;
        this.m_cubeOptions = cubeOptions;
        this.m_ranges = ranges;
        this.m_propertyPanel = new PADataFieldPropertyPanel(this);
        this.getContentPane().setPropertyPanel(this.m_propertyPanel, false, false);
    }

    public PADataFieldNode(PADataFieldsNode parent, ExposedField field) throws Exception {
        super(field.getUniqueName());
        this.m_parent = parent;
        this.setExposedField(field);
        this.m_propertyPanel = new PADataFieldPropertyPanel(this);
        this.getContentPane().setPropertyPanel(this.m_propertyPanel, false, false);
    }

    public void refresh() {
        try {
            this.m_propertyPanel.refresh();
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public void inFocus() {
        this.m_propertyPanel.updateSelectedTab();
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "pa_data_fields.htm");
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public void setFieldName(String fieldName) {
        this.m_fieldName = fieldName;
    }

    public int getFieldType() {
        return this.m_fieldType;
    }

    public boolean isMeasure() {
        return this.m_bIsMeasure;
    }

    public Object[] getRanges() {
        return this.m_ranges;
    }

    private void setRanges(Object[] ranges) {
        if (ranges != null && ranges.length == 0) {
            ranges = null;
        }
        this.m_ranges = ranges;
    }

    public int getCubes() {
        return this.m_cubes;
    }

    public void setCubes(int cubes) {
        this.m_cubes = cubes;
    }

    private void setCubes(Collection cubeTypeCollection) {
        int cubes = 0;
        Iterator i = cubeTypeCollection.iterator();
        while (i.hasNext()) {
            cubes |= ((UDFMetaData.CubeType)i.next()).getOrdinal();
        }
        this.setCubes(cubes);
    }

    public int getCubeOptions() {
        return this.m_cubeOptions;
    }

    public void setCubeOptions(int cubeOptions) {
        if (cubeOptions != this.m_cubeOptions) {
            this.m_cubeOptions = cubeOptions;
            this.m_propertyPanel.rebuildLayout();
        }
    }

    public boolean isExposedToFactTablesOnly() {
        return (this.getCubeOptions() & 0x40) != 0;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, PAActionCommand.DELETE) == 0) {
                this.deleteDataField();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.EDIT) == 0) {
                this.editDataField();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{PAActionCommand.EDIT, PAActionCommand.DELETE, "Add Separator", PAActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        if (VWStringUtils.compare(actionCMD, PAActionCommand.EDIT) == 0) {
            return !this.m_parent.getPANode().isStarted();
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.DELETE) == 0) {
            return !this.m_parent.getPANode().isStarted();
        }
        return true;
    }

    public boolean showDeleteIcon() {
        return !this.m_parent.getPANode().isStarted();
    }

    public void deleteDataField() {
        try {
            if (!this.displayConfirmation(VWResource.DeleteDataFieldConfirmation)) {
                return;
            }
            this.m_parent.disposeDataField(this.getName());
            super.delete();
        }
        catch (Exception e) {
            this.displayError(e);
        }
    }

    public void editDataField() throws Exception {
        PADataFieldWizard wizard = new PADataFieldWizard(this.m_parent, this);
        wizard.setVisible(true);
        this.refresh();
    }

    protected void setExposedField(ExposedField field) throws Exception {
        this.setIcons(field.isMeasure());
        this.m_fieldName = field.get_FieldName();
        this.m_fieldType = field.getType().getOrdinal();
        this.m_bIsMeasure = field.isMeasure();
        this.setCubes(field.getCubes());
        this.m_cubeOptions = field.getCubeOptions();
        if (field.hasRanges()) {
            this.setRanges(field.getRanges().toArray());
        }
    }

    private void setIcons(boolean bMeasure) {
        if (bMeasure) {
            this.setIcon16(iconMeasure16);
            this.setIcon32(iconMeasure32);
        } else {
            this.setIcon16(iconDimension16);
            this.setIcon32(iconDimension32);
        }
    }
}

